#include "precompiled.h"
#include "FpsTimer.h"
#include "common.h"

namespace RTCam {

#pragma warning(push)
#pragma warning(disable: 4351)

FpsTimer::FpsTimer(void) :
	m_isReset(true),
	m_lowestDelta(0),
	m_highestDelta(0),
	m_deltaSamples(),
	m_currentSample(0)
{
}

#pragma warning(pop)

FpsTimer::~FpsTimer(void)
{
}

void FpsTimer::Update( float delta )
{
	if(m_isReset) {
		m_isReset = false;
		m_currentSample = 0;

		for(float& sample : m_deltaSamples) {
			sample = delta;
		}
		m_lowestDelta = delta;
		m_highestDelta = delta;
	} else {
		int curIndex = m_currentSample % kNumSamples;
		m_deltaSamples[curIndex] = delta;

		m_lowestDelta = std::min(m_lowestDelta, delta);
		m_highestDelta = std::max(m_highestDelta, delta);
	}

	++m_currentSample;
}

void FpsTimer::Reset()
{
	m_isReset = true;
}


float FpsTimer::GetAvgFps()
{
	return 1.0f / GetAvgDelta();
}

float FpsTimer::GetMinDelta()
{
	float minDelta = FLT_MAX;
	for(float delta : m_deltaSamples) {
		minDelta = std::min(minDelta, delta);
	}
	return minDelta;
}

float FpsTimer::GetAvgDelta()
{
	float avgDelta = 0;

	for(float delta : m_deltaSamples) {
		avgDelta += delta;
	}

	avgDelta /= kNumSamples;
	return avgDelta;
}

float FpsTimer::GetMaxDelta()
{
	float maxDelta = 0;
	for(float delta : m_deltaSamples) {
		maxDelta = std::max(maxDelta, delta);
	}
	return maxDelta;
}

float FpsTimer::GetMinDeltaSinceReset()
{
	return m_lowestDelta;
}

float FpsTimer::GetMaxDeltaSinceReset()
{
	return m_highestDelta;
}

} // end namespace